IF OBJECT_ID('UFD_BC_LANC_EXTRATO_PREV_COMP_SINT') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_BC_LANC_EXTRATO_PREV_COMP_SINT
	END
	
GO	

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

----SELECT * FROM UFD_BC_LANC_EXTRATO_PREV_COMP(1,3,'2007-10-11','2007-11-11',0) ORDER BY CD_BC_LANC
CREATE  FUNCTION [dbo].[UFD_BC_LANC_EXTRATO_PREV_COMP_SINT](
--CREATE FUNCTION UFD_BC_LANC_EXTRATO_PREV_COMP_SINT(
												@CD_EMP	INT,
												@CD_CNT	INT,
												@DT_INI	DATETIME,
												@DT_FIM	DATETIME,
												@TP_COMPES INT --0 Não Compensado; 1 - Compensado
												)
RETURNS @BC_LANC_EXTRATO TABLE(
												CD_EMP		INT,
												CD_RET		INT,
												DS_RET		NVARCHAR(100),												
												VLR_RET		MONEY)
AS
BEGIN

--Usada para auxiliar o calculo do saldo
DECLARE @VLR_SLD				MONEY
DECLARE @SLD_INI				MONEY
DECLARE @VLR_BC_LANC			MONEY
DECLARE @VLR_LIMITE				MONEY
DECLARE @DT_ATUAL				DATETIME



SET @SLD_INI = 0 
SET @VLR_BC_LANC = 0



SET @DT_ATUAL = (SELECT CONVERT(VARCHAR(10),GETDATE(), 101))

SET @DT_INI = (SELECT CONVERT(VARCHAR(10),@DT_INI, 101))
SET @DT_FIM = (SELECT CONVERT(VARCHAR(10),@DT_FIM, 101))

SET @SLD_INI = ISNULL((SELECT DBO.UFD_BC_LANC_EXTRATO_SLD(@CD_EMP,@CD_CNT, DATEADD(day, 1, @DT_FIM),0)),0)


--VALOR REFERENTE AOS DEMAIS LANÇAMENTOS BANCÁRIOS
SET @VLR_BC_LANC = ISNULL((SELECT
						SUM(CASE WHEN BC_LANC.TP_LANC = 0 THEN VLR_LANC ELSE -VLR_LANC END) AS VLR_LANC
					FROM
						BC_LANC
						INNER JOIN GLB_DOC ON
							BC_LANC.CD_EMP = GLB_DOC.CD_EMP AND 
							BC_LANC.CD_DOC = GLB_DOC.CD_DOC
						LEFT OUTER JOIN BC_CONCILICAO_EXTRATO_DDA A ON 
							A.CD_BC_LANC = BC_LANC.CD_BC_LANC
							AND A.STS_CONCILIACAO  = 1
							AND A.DT_MOV > @DT_FIM
					WHERE
						BC_LANC.CD_EMP = @CD_EMP
						AND BC_LANC.CD_CNT = @CD_CNT
						AND BC_LANC.DT_LANCTO <= @DT_FIM
						AND A.CD_BC_LANC IS NULL
						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								BC_LANC_CONC
							WHERE
								BC_LANC_CONC.CD_EMP		= BC_LANC.CD_EMP AND
								BC_LANC_CONC.CD_BC_LANC = BC_LANC.CD_BC_LANC AND 
								BC_LANC_CONC.DT_COMPES <= @DT_FIM)
						AND NOT EXISTS (
							SELECT
								CD_BC_LANC
							FROM
								V_BC_CHQ_LANC_COMPENSADO
							WHERE
								V_BC_CHQ_LANC_COMPENSADO.CD_EMP		= BC_LANC.CD_EMP AND
								V_BC_CHQ_LANC_COMPENSADO.CD_BC_LANC = BC_LANC.CD_BC_LANC AND
								V_BC_CHQ_LANC_COMPENSADO.CD_CNT		= BC_LANC.CD_CNT AND
								V_BC_CHQ_LANC_COMPENSADO.DT_COMPES <= @DT_FIM)),0)


--PEGANDO O LIMITE DA CONTA
SET @VLR_LIMITE = ISNULL((SELECT 
					ISNULL(VLR_LIMITE,0)
				  FROM 
					BC_CONTAS 
			      WHERE 
					CD_EMP = @CD_EMP
					AND CD_CNT = @CD_CNT),0)


INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 4, '(-) Lançamentos bancários não conciliados', @VLR_BC_LANC)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 5, 'Saldo disponível', @SLD_INI - @VLR_BC_LANC )

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 6, 'Limite da conta', @VLR_LIMITE)

INSERT INTO @BC_LANC_EXTRATO (CD_EMP, CD_RET, DS_RET, VLR_RET)
					VALUES (@CD_EMP, 7, 'Saldo + Limite',@SLD_INI - @VLR_BC_LANC + @VLR_LIMITE)

RETURN
END
GO


